/*
 * XXXX 
 *
 * Fecha 15/05/2007
 * 
 *  
 */
 
package com.ejie.p06b.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.fop.apps.Driver;
import org.xml.sax.InputSource;

import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.pdf.P06BIPDF;
import com.ejie.p06b.util.P06BParametros;

/**
	Servlet que genera el pdf y lo enva a la ruta correspondiente
	Posibles Excepciones que se capturan:
		-- Excepcin genrica
*/
public class P06BPDFServlet extends P06BServlet {
	/**
	Proceso de la servlet
	*
	*/
	
	public void init() throws ServletException {
	}
	//Process the HTTP Get request
	public void doGet(HttpServletRequest request, HttpServletResponse response) {
		P06BLog.send(2,this.getClass().getName(), "Inicio");
		
		String tipoPDF= request.getParameter("tipoPDF");
		String ficheroPDF="";
		
		try {		
			P06BIPDF pdfClass = (P06BIPDF) Class.forName("com.ejie.p06b.pdf."+tipoPDF).newInstance();
			
			String xmlPdf = pdfClass.getXmlPdf(request);
			String xsltFichero = pdfClass.getXsltFichero(request);
			
			imprimir(request, response, xsltFichero, xmlPdf);
			
			P06BLog.send(2,this.getClass().getName(), "Fin");
		} catch (Exception e) {
			P06BLog.send(2,this.getClass().getName(),"_________ doGet : EXCEPCION:  " + e.getMessage()+" ---> "+e.toString());
			manejarErrores (request, response, e);
	        return;
		}
	}
	
	//Process the HTTP Post request
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doGet(request, response);
	}
		
	protected void imprimir(HttpServletRequest request,
            HttpServletResponse response,
            String astrXSLTFichero, 
            String aXML)
   {
    	try{
	        TransformerFactory tFactory = TransformerFactory.newInstance();
	        if(P06BParametros.get("paginasXSL.path") != null){
	        	P06BLog.send(2,this.getClass().getName()," -- paginasXSL.path --> " + P06BParametros.get("paginasXSL.path"));
	        }else{
	        	P06BLog.send(2,this.getClass().getName()," -- paginasXSL.path Es Nuloooo");
	        }
	        
	        if(astrXSLTFichero != null){
	        	P06BLog.send(2,this.getClass().getName()," -- astrXSLTFichero -->" + astrXSLTFichero);
	        }else{
	        	P06BLog.send(2,this.getClass().getName()," -- astrXSLTFichero Es Nulo");
	        }
	        
	        Source foXslSource   = new StreamSource(getClass().getResourceAsStream(P06BParametros.get("paginasXSL.path")+astrXSLTFichero));
	        if(foXslSource != null){
	        	P06BLog.send(2,this.getClass().getName()," -- foXslSource --> " + foXslSource);
	        }else{
	        	P06BLog.send(2,this.getClass().getName()," -- foXslSource Es Nulo");
	        }
	        
	        Transformer pdfTransformer = tFactory.newTransformer(foXslSource);
	        if(pdfTransformer != null){
	        	P06BLog.send(2,this.getClass().getName()," -- pdfTransformer --> " + pdfTransformer);
	        }else{
	        	P06BLog.send(2,this.getClass().getName()," -- pdfTransformer Es Nulooo");
	        }
	        
	        Writer out = new StringWriter();
	        if(aXML == null){
	        	P06BLog.send(2,this.getClass().getName()," -- aXML Es Nulooo");
	        }else{
	        	P06BLog.send(2,this.getClass().getName()," -- aXML --> " + aXML);
	        }
	        Source xmlSource = new StreamSource(new StringReader(aXML));

	        if(out != null ){
	        	P06BLog.send(2,this.getClass().getName()," -- out --> " + out);
	        }else{
	        	P06BLog.send(2,this.getClass().getName()," -- out Es Nulooo");
	        }
	        pdfTransformer.transform(xmlSource, new StreamResult(out));

	        out.close();

	        String fopstring = out.toString();

	        InputSource foSource = new InputSource(new StringReader(fopstring));
	        if(foSource != null){
	        	P06BLog.send(2,this.getClass().getName()," -- foSource --> " + foSource);
	        }else{
	        	P06BLog.send(2,this.getClass().getName()," -- foSource ES Nulooo");
	        }
	        ByteArrayOutputStream baout = new ByteArrayOutputStream();

	        Driver driver = new Driver(foSource , baout);
	        if(driver != null){
	        	P06BLog.send(2,this.getClass().getName()," -- driver --> " + driver);
	        }else{
	        	P06BLog.send(2,this.getClass().getName()," -- driver Es Nulooo");
	        }
	        
	        response.setContentType("application/pdf");
	        driver.setRenderer(Driver.RENDER_PDF);
	        driver.run();

	        byte[] content = baout.toByteArray();
	        if(content != null){
	        	P06BLog.send(2,this.getClass().getName()," -- content --> " + content);
	        }else{
	        	P06BLog.send(2,this.getClass().getName()," -- content Es Nulooo");
	        }

	        response.setContentLength(content.length);
	        response.getOutputStream().write(content);
	        response.getOutputStream().flush();
	        response.flushBuffer();
	        
		}catch (IOException e){             
    		P06BLog.send(2,this,"_________ IOException  " + e.getMessage());
		}catch (Exception e){
    		P06BLog.send(2,this,"_________ p06bEParseoException  " + e.getMessage()+"--->"+e.toString());
		} 	

    	return;        
   }
	
	
	
	
}
